<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" 
Inherits="Voxco.Reporting.Report_ReportStatisticsResultCode" Title="Untitled Page" Theme="voxco" Codebehind="ReportStatisticsResultCode.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">
	<!-- START OBJECT DATA SOURCE -->	
	<!-- result code / page 1 -->
	<asp:ObjectDataSource ID="AvailableResultCodeDataSource" runat="server" SelectMethod="GetAvailable" TypeName="Voxco.Reporting.DataSource.ResultCodes">
	</asp:ObjectDataSource>
    <asp:ObjectDataSource ID="FilteredResultCodeDataSource" runat="server" SelectMethod="GetFiltered" TypeName="Voxco.Reporting.DataSource.ResultCodes">
    </asp:ObjectDataSource>            
    <asp:ObjectDataSource ID="LanguagesDataSource" runat="server" OldValuesParameterFormatString="original_{0}" SelectMethod="GetQuestionnaireLanguages" TypeName="Voxco.Reporting.DataSource.LanguagesDS">
	</asp:ObjectDataSource>
	
	<!-- statistic / page 2 -->
	<asp:ObjectDataSource ID="StatisticDataSource" runat="server" SelectMethod="Get" TypeName="Voxco.Reporting.DataSource.Statistic">
	</asp:ObjectDataSource>
	
	<!-- Question statistics / page 3 -->
	<asp:ObjectDataSource	ID="VariablesDataSource" runat="server" SelectMethod="GetVariables" TypeName="Voxco.Reporting.DataSource.QuestionStatistics">
	</asp:ObjectDataSource>
	<asp:ObjectDataSource	ID="QuestionStatisticCreationOperationsDataSource" runat="server" SelectMethod="GetCreationOperations" TypeName="Voxco.Reporting.DataSource.QuestionStatistics">
	</asp:ObjectDataSource>
	<asp:ObjectDataSource	ID="QuestionStatisticEditionOperationsDataSource" runat="server" SelectMethod="GetEditionOperations" TypeName="Voxco.Reporting.DataSource.QuestionStatistics">
	</asp:ObjectDataSource>
	<asp:ObjectDataSource	ID="QuestionStatisticOptionsDataSource" runat="server" SelectMethod="GetOptions" TypeName="Voxco.Reporting.DataSource.QuestionStatistics">
	</asp:ObjectDataSource>
	<asp:ObjectDataSource	ID="QuestionStatistics" runat="server" SelectMethod="Get" UpdateMethod="Update" DeleteMethod="Delete" InsertMethod="Insert"
		TypeName="Voxco.Reporting.DataSource.QuestionStatistics"
		OnDeleted="QuestionStatistics_Deleted" 
		OnInserted="QuestionStatistics_Inserted" 
		OnUpdated="QuestionStatistics_Updated" >
		<InsertParameters>
			<asp:Parameter Name="Name" Type="String" />
			<asp:Parameter Name="Operation" Type="String" />
			<asp:Parameter Name="Option" Type="String" />
			<asp:Parameter Name="NbOfDecimals" Type="String" />
			<asp:Parameter Name="Variable" Type="String" />
			<asp:Parameter Name="HighDelimiter" Type="String" />
			<asp:Parameter Name="LowDelimiter" Type="String" />
			<asp:Parameter Name="Id" Type="Int32" />
			<asp:Parameter Name="CanBeDeleted" Type="String" />
		</InsertParameters>
		<UpdateParameters>
			<asp:Parameter Name="Id" Type="Int32" />
			<asp:Parameter Name="Name" Type="String" />
			<asp:Parameter Name="Operation" Type="String" />
			<asp:Parameter Name="Option" Type="String" />
			<asp:Parameter Name="NbOfDecimals" Type="String" />
			<asp:Parameter Name="Variable" Type="String" />
			<asp:Parameter Name="HighDelimiter" Type="String" />
			<asp:Parameter Name="LowDelimiter" Type="String" />
			<asp:Parameter Name="CanBeDeleted" Type="String" />
		</UpdateParameters>
		<DeleteParameters>
			<asp:Parameter Name="Id" Type="Int32" />
			<asp:Parameter Name="CanBeDeleted" Type="String" />
		</DeleteParameters>
	</asp:ObjectDataSource>
	
	
	<!-- treeview -->
	<asp:ObjectDataSource ID="SelectedResultCodeDataSource" runat="server" SelectMethod="GetSelected" TypeName="Voxco.Reporting.DataSource.ResultCodes">
	</asp:ObjectDataSource>
	
    <!-- END OBJECT DATA SOURCE -->
    
    <telerik:RadScriptBlock ID="ScriptManager" runat="server">
		<script language="javascript" type="text/javascript">

		        if (Telerik.Web.UI.RadTreeView != undefined) {
		            Telerik.Web.UI.RadTreeView.prototype.saveClientState = function () {
		                return "{\"expandedNodes\":" + this._expandedNodesJson +
		                    ",\"collapsedNodes\":" + this._collapsedNodesJson +
		                    ",\"logEntries\":" + this._logEntriesJson +
		                    ",\"selectedNodes\":" + this._selectedNodesJson +
		                    ",\"checkedNodes\":" + this._checkedNodesJson +
		                    ",\"scrollPosition\":" + Math.round(this._scrollPosition) + "}";
		            }
		        }

				function DeleteClick()
				{
					return confirm('<%= TranslateForJS("QuestionStatisticDeleteSelected") %>');
				}

				function UpdateClick()
				{
					return confirm('<%= TranslateForJS("QuestionStatisticUpdateSelected") %>');
				}
				// ********************
				// Result code grids
				function btnAddFilteredResultCode_OnClick()
				{
					$find("<%= RadAjaxPanelResultCode.ClientID %>").ajaxRequest("addFilteredResultCode");
					return false;
				}
				
				function btnRemoveFilteredResultCode_OnClick()
				{
					$find("<%= RadAjaxPanelResultCode.ClientID %>").ajaxRequest("removeFilteredResultCode");
					return false;
				}
				
				function btnAddResultCode_OnClick()
				{
					$find("<%= RadAjaxPanelResultCode.ClientID %>").ajaxRequest("addResultCode");
					return false;
				}
				
				function btnAddResultCodeToNewGroup_OnClick()
				{
					$find("<%= RadAjaxPanelResultCode.ClientID %>").ajaxRequest("addGroupResultCode");
					return false;
				}
				
			
				// ********************
				// Statistics
				function btnAddStatistic_Click()
				{
					$find("<%= RadAjaxPanelResultCode.ClientID %>").ajaxRequest("addStatistic");
					return false;
				}
				
				function btnAddStatisticToNewGroup_Click()
				{
					$find("<%= RadAjaxPanelResultCode.ClientID %>").ajaxRequest("addGroupStatistic");
					return false;
				}
				
				// ********************
				// Question statistic
				function btnAddQuestionStatistic_Click()
				{
					$find("<%= RadAjaxPanelResultCode.ClientID %>").ajaxRequest("addQuestionStatistic");
					return false;
				}
				
				function btnAddQuestionStatisticToNewGroup_Click()
				{
					$find("<%= RadAjaxPanelResultCode.ClientID %>").ajaxRequest("addGroupQuestionStatistic");
					return false;
				}								
				
				// ********************
				// treeview
				function OnCheckedNode(node, eventArgs)
				{					
					$find("<%= treeSelectedResultCodesAjaxPanel.ClientID %>").ajaxRequest("SetSelectedNodes");
				}
				
				function UncheckGroupNodesAllNodes()
				{
					var tree = $find("<%= treeSelectedResultCodes.ClientID %>"); 
			        var _nodes = tree.get_allNodes();
					for (var i = 0; i < _nodes.length; i++)
					{
						if( _nodes[i].get_value().substring(0, 3) == "OG:" )
						{
							_nodes[i].uncheck();
						}
					}
					$find("<%= treeSelectedResultCodesAjaxPanel.ClientID %>").ajaxRequest("SetSelectedNodes");
					return false;
				}

				function CheckGroupNodesAllNodes()
				{
					var tree = $find("<%= treeSelectedResultCodes.ClientID %>");  
			        var _nodes = tree.get_allNodes();
					for (var i = 0; i < _nodes.length; i++)
					{
						if( _nodes[i].get_value().substring(0, 3) == "OG:" )
						{
							_nodes[i].check();
						}
					}
					$find("<%= treeSelectedResultCodesAjaxPanel.ClientID %>").ajaxRequest("SetSelectedNodes");
					return false;
				}
				
				function OnClickedNode(node, eventArgs)
				{						
					if (node.get_selectedNode().get_value().substring(0, 3) != "CS:")
					{
						return;
					}
					OpenWinCustomStatistic(node.get_selectedNode().get_value().substring(3, 4), node.get_selectedNode()._parent.get_value().substring(3, 6))
				}				
				
				function lnkMoveUp_Click()
				{
					$find("<%= treeSelectedResultCodesAjaxPanel.ClientID %>").ajaxRequest("MoveUp");
					return false;
				}
				
				function lnkMoveDown_Click()
				{
					$find("<%= treeSelectedResultCodesAjaxPanel.ClientID %>").ajaxRequest("MoveDown");
					return false;
				}
				
				function treeSelectedDropTest(source, dest, events)
				{                
					if (dest._destNode != null) 
					{
						if(dest._destNode.get_value().substring(0,3) == "OG:" && source.get_parent() != null &&  source.get_parent() != dest._destNode.get_value())
						{
							return true;
						}
						// allow moving all group's elements in another group
						if(source.get_selectedNode().get_value().substring(0, 3) == "OG:" && dest.get_destNode().get_value().substring(0, 3) == "OG:")
						{
							return true;
						}
					}
					else
					{
						return false;
					}
				}
				
				// ********************
				// Pop up custom statistic
				function OpenWinCustomStatistic(_statisticCustomID,_groupStatisticId)
				{
				   
					url = "ReportCustomStatistics.aspx?GroupStatisticId="+_groupStatisticId+"&StatisticCustomID="+_statisticCustomID;
	                var oWnd = $find("<%= CustomStatisticsRadWindow.ClientID %>");
                    oWnd.setUrl(url);
                	oWnd.setSize (800, 410);
					oWnd.add_close(OnClientClose);
					oWnd.set_modal(true);	
					oWnd.show();				
				}
				
				function OnClientClose(oWnd,eventArgs)
				{					
					$find("<%= treeSelectedResultCodesAjaxPanel.ClientID %>").ajaxRequest("Refresh");
					var oWnd = $find("<%= CustomStatisticsRadWindow.ClientID %>");
					oWnd.remove_close(OnClientClose);
				}
				
				function displayAlert(message)
				{
					radalert(message, 300, 200, "Alert");			
				}
							
			</script>
	</telerik:RadScriptBlock>
    
	<telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" Transparency="25" MinDisplayTime="200" InitialDelayTime="20">
		<VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
    </telerik:RadAjaxLoadingPanel>
    
    <telerik:RadWindowManager ID="RadWindowManager1" runat="server" VisibleStatusbar="false" ReloadOnShow="true" 
    Behaviors="Close" EnableEmbeddedSkins="false" EnableEmbeddedBaseStylesheet="false" Skin="Voxco">
		<Windows>
			<telerik:RadWindow ID="CustomStatisticsRadWindow"  ReloadOnShow="true"  runat="server" Behaviors="Move, Reload" NavigateUrl="ReportCustomStatistics.aspx">
			</telerik:RadWindow>
		</Windows>
	</telerik:RadWindowManager>
    	
	<telerik:radtabstrip id="StatisticPresentationTabs" runat="server" SelectedIndex="0" MultiPageID="StatisticPresentationPages" 
		Orientation="HorizontalBottom" Height="25px" ScrollChildren="false">
		<Tabs>                    
			<telerik:RadTab runat="server" Text="<%$ Resources:Resource, ResultCodes%>" ImageUrl="~/icons/ico16_linesStates.gif"></telerik:RadTab>
			<telerik:RadTab runat="server" Text="<%$ Resources:Resource, Statistics%>" ImageUrl="~/icons/ico16_AgentsStatistics.gif"></telerik:RadTab>
			<telerik:RadTab runat="server" Text="<%$ Resources:Resource, QuestionStatistics%>" ImageUrl="~/icons/ico16_AgentsStatistics.gif"></telerik:RadTab>
		</Tabs>
	</telerik:radtabstrip>
	
	<telerik:RadAjaxPanel ID="RadAjaxPanelResultCode" runat="server" EnableAJAX="true" OnAjaxRequest="RadAjaxPanelResultCode_OnAjaxRequest" LoadingPanelID="MainAjaxLoadingPanel">
		
		<div style="float: left; width: 65%;">
		
		<telerik:radmultipage runat="server" id="StatisticPresentationPages" SelectedIndex="0" Height="450px" ScrollBars="None">
			
			<!-- PAGE 1 / Result code -->
			<telerik:RadPageView runat="server" id="ResultCodes">

					<div runat="server" id="DataLanguageListDiv" style="text-align: right; margin-right: 50px;"> 
						<asp:Label ID="DataLanguageLabel" runat="server"  Text="<%$ Resources:Resource, ResultCodeLabelLanguage %>"></asp:Label>:
						<asp:DropDownList ID="DataLanguageList" runat="server" Font-Size="8pt" Width="155px" DataSourceID="LanguagesDataSource" 
						AutoPostBack="true"  DataTextField="LanguageLabel" DataValueField="LanguageCode" 
						OnSelectedIndexChanged="DataLanguageList_SelectedIndexChanged"/>
					</div>
					
					<div style="float: left; width: 43%;">				
						<telerik:RadGrid id="grdAvailableResultCodes" runat="server" AutoGenerateColumns="False"
						AllowMultiRowSelection="True" DataSourceID="AvailableResultCodeDataSource"
						AllowSorting="True" SortingSettings-SortToolTip="<%$ Resources:Resource, SortingHeader %>" 
						SortingSettings-SortedAscToolTip="<%$ Resources:Resource, SortingHeader %>"  
						SortingSettings-SortedDescToolTip="<%$ Resources:Resource, SortingHeader %>"
						Height="360px" EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
							
							<ClientSettings>
								<Selecting UseClientSelectColumnOnly="True" AllowRowSelect="True"  />
								<Scrolling AllowScroll="True" UseStaticHeaders="True"  />                   
							</ClientSettings>
			                
							<MasterTableView DataSourceID="AvailableResultCodeDataSource" NoMasterRecordsText="<%$ Resources:Resource, NoRecords %>">
								<SortExpressions>
									<telerik:GridSortExpression FieldName="CodeText" />
								</SortExpressions>
								<Columns>
									<telerik:GridBoundColumn DataField="Code" DataType="System.Int32" Display="False" HeaderText="Code" UniqueName="Code">
									</telerik:GridBoundColumn>
									<telerik:GridBoundColumn DataField="ProjectId" DataType="System.Int32" Display="False" HeaderText="ProjectId" UniqueName="ProjectId">
									</telerik:GridBoundColumn>
									<telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
										<HeaderStyle Width="30px" HorizontalAlign="Left" />
										<ItemStyle Width="30px" HorizontalAlign="Left" />
									</telerik:GridClientSelectColumn>
									<telerik:GridBoundColumn DataField="CodeText" HeaderText="<%$ Resources:Resource, AvailableResultCodes %>" UniqueName="CodeText">
										<HeaderStyle Width="90%" Wrap="False" HorizontalAlign="Left" />
										<ItemStyle Width="90%" Wrap="False" HorizontalAlign="Left" />
									</telerik:GridBoundColumn>
								</Columns>
							</MasterTableView>
			            
							<SortingSettings SortedAscToolTip="Click here to sort" SortedDescToolTip="Click here to sort" />
						
						</telerik:RadGrid>
					</div>
					
					<div style="float: left; height: 400px;">
						<div class="arrows">
							<asp:ImageButton ID="btnAddFilteredResultCode" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClientClick="javascript: return btnAddFilteredResultCode_OnClick();" /><br />
							<asp:ImageButton ID="btnRemoveFilteredResultCode" runat="server" ImageUrl="~/icons/arrow_left_blue.png" OnClientClick="javascript: return btnRemoveFilteredResultCode_OnClick();" />
						</div>
					</div>
					
					<div style="float: left; width: 43%;">
						<telerik:RadGrid ID="grdFilteredResultCodes" runat="server"
						AllowSorting="True" DataSourceID="FilteredResultCodeDataSource"
						SortingSettings-SortToolTip="<%$ Resources:Resource, SortingHeader %>"
						SortingSettings-SortedAscToolTip="<%$ Resources:Resource, SortingHeader %>" 
						SortingSettings-SortedDescToolTip="<%$ Resources:Resource, SortingHeader %>"
						AllowMultiRowSelection="True" AutoGenerateColumns="False" Height="360px"
						EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
							
							<ClientSettings>
								<Selecting  AllowRowSelect="True" UseClientSelectColumnOnly="True" />
								<Scrolling AllowScroll="True" UseStaticHeaders="True" />
							</ClientSettings>
							
							<MasterTableView DataSourceID="FilteredResultCodeDataSource" NoMasterRecordsText="<%$ Resources:Resource, NoRecords %>">
								<SortExpressions>
									<telerik:GridSortExpression FieldName="CodeText" />
								</SortExpressions>
								<Columns>
									<telerik:GridBoundColumn DataField="Code" Display="False" HeaderText="Code" UniqueName="Code">
									</telerik:GridBoundColumn>
									<telerik:GridBoundColumn DataField="ProjectId" DataType="System.Int32" Display="False" HeaderText="ProjectId" UniqueName="ProjectId">
									</telerik:GridBoundColumn>
									<telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
										<HeaderStyle Width="30px" HorizontalAlign="Left" />
										<ItemStyle Width="30px" HorizontalAlign="Left" />
									</telerik:GridClientSelectColumn>
									<telerik:GridBoundColumn DataField="CodeText" HeaderText="<%$ Resources:Resource, FilteredResultCodes %>" UniqueName="CodeText">
										<HeaderStyle Width="90%" HorizontalAlign="Left" Wrap="false" />
										<ItemStyle Wrap="false" Width="90%" HorizontalAlign="Left" />
									</telerik:GridBoundColumn>
								</Columns>						
							</MasterTableView>					
							
							<SortingSettings SortedAscToolTip="Click here to sort" SortedDescToolTip="Click here to sort" />
						
						</telerik:RadGrid>
					</div>
					
					<div style="float: left; height: 400px;">
						<div class="arrows">
							<asp:ImageButton ID="btnAddResultCode" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClientClick="javascript: return btnAddResultCode_OnClick();" ToolTip="<%$ Resources:Resource, AddSelectedItems %>" /><br />
							<asp:ImageButton ID="btnAddResultCodeToNewGroup" runat="server" ImageUrl="~/icons/arrow_right_green.png" OnClientClick="javascript: return btnAddResultCodeToNewGroup_OnClick();" ToolTip="<%$ Resources:Resource, AddSelectedItemsToNewGroup %>" />
						</div>
					</div>

			</telerik:RadPageView>		
			
			<!-- PAGE 2 / Statistics -->
			<telerik:RadPageView runat="server" id="Statistics" >
				<br />
				<div style="float: right; height: 400px;">
					<div class="arrows">
						<asp:ImageButton ID="btnAddStatistic" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClientClick="javascript: return btnAddStatistic_Click();" ToolTip="<%$ Resources:Resource, AddSelectedItems %>" />
						<asp:ImageButton ID="ImageButton1" runat="server" ImageUrl="~/icons/arrow_right_green.png" OnCLientClick="javascript: return btnAddStatisticToNewGroup_Click();" ToolTip="<%$ Resources:Resource, AddSelectedItemsToNewGroup %>" />
					</div>
				</div>
				
				<div style="float: right; width: 60%;">				
					<telerik:RadGrid ID="grdStatistic" runat="server" 
					AllowSorting="True" DataSourceID="StatisticDataSource"
					 SortingSettings-SortToolTip="<%$ Resources:Resource, SortingHeader%>" 
					 SortingSettings-SortedAscToolTip="<%$ Resources:Resource, SortingHeader%>" 
					 SortingSettings-SortedDescToolTip="<%$ Resources:Resource, SortingHeader%>" 
					  AllowMultiRowSelection="true" AutoGenerateColumns="false"  Height="360px"
					 EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
						
						<ClientSettings>
							<Selecting UseClientSelectColumnOnly="True" AllowRowSelect="True" />
							<Scrolling AllowScroll="True" UseStaticHeaders="True" />
						</ClientSettings>
						
						<MasterTableView DataSourceID="StatisticDataSource">
							<Columns>
								<telerik:GridBoundColumn UniqueName="StatisticId" DataType="System.Int32" DataField="StatisticId" HeaderText="Id"  Display="false">
								</telerik:GridBoundColumn>
								<telerik:GridClientSelectColumn UniqueName="Selected" DataType="System.Boolean">
									<HeaderStyle Width="30px" HorizontalAlign="Left" />
									<ItemStyle Width="30px" HorizontalAlign="Left" />
								</telerik:GridClientSelectColumn>							
								<telerik:GridBoundColumn DataField="StatisticName" HeaderText="<%$ Resources:Resource, AvailableStatistics %>" UniqueName="StatisticName">
									<HeaderStyle HorizontalAlign="Left" Wrap="true" />
									<ItemStyle HorizontalAlign="Left" Wrap="true" />
								</telerik:GridBoundColumn>
							</Columns>						
						</MasterTableView>
					</telerik:RadGrid>
				</div>			
				
			</telerik:RadPageView>
			
			<!-- PAGE 3 / Question statistics -->
			<telerik:RadPageView runat="server" id="QuestionStatisticsPage">
				<br />
				<div style="float: right; height: 400px;">
					<div class="arrows">
						<asp:ImageButton ID="ImageButton2" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClientClick="javascript: return btnAddQuestionStatistic_Click();" ToolTip="<%$ Resources:Resource, AddSelectedItems %>" />
						<asp:ImageButton ID="ImageButton3" runat="server" ImageUrl="~/icons/arrow_right_green.png" OnClientClick="javascript: return btnAddQuestionStatisticToNewGroup_Click();" ToolTip="<%$ Resources:Resource, AddSelectedItemsToNewGroup %>" />
					</div>
				</div>
				
				<telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="MainAjaxLoadingPanel">
					
					<div style="margin-right: 25px; ">
						<telerik:RadGrid ID="grdQuestionStatistic" runat="server" AllowSorting="True"
						 SortingSettings-SortToolTip="<%$ Resources:Resource, SortingHeader %>"
						 AllowAutomaticInserts="True" AllowAutomaticUpdates="True" AllowAutomaticDeletes="true"
						 SortingSettings-SortedAscToolTip="<%$ Resources:Resource, SortingHeader %>" 
						 SortingSettings-SortedDescToolTip="<%$ Resources:Resource, SortingHeader %>" 
						 OnItemCreated="grdQuestionStatistic_ItemCreated"								 
						 AllowMultiRowSelection="True" AllowMultiRowEdit="false"
						 DataSourceID="QuestionStatistics" OnItemCommand="QuestionStatisticGrid_ItemCommand" Height="360px"
						 EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">				
							
							<MasterTableView ClientDataKeyNames="Id"></MasterTableView>
							
							<ClientSettings>								
								<Selecting AllowRowSelect="True" UseClientSelectColumnOnly="True" />
								<Scrolling AllowScroll="True" UseStaticHeaders="True" />
							</ClientSettings>

							<MasterTableView CommandItemDisplay="Top" AutoGenerateColumns="False" DataSourceID="QuestionStatistics"
							EditMode="InPlace" DataKeyNames="Id,CanBeDeleted" Width="800px">
								<CommandItemTemplate>
									<div style="padding: 0 5px;">
										<asp:LinkButton ID="btnEditSelected" runat="server" CommandName="EditSelected" 
										Visible='<%# grdQuestionStatistic.EditIndexes.Count == 0 && !grdQuestionStatistic.MasterTableView.IsItemInserted %>'>
											<img style="border:0px;vertical-align:middle;" alt="" src="../icons/Edit.gif" />
											<asp:Literal ID="lblEdit" runat="server" Text="<%$ Resources:Resource,Edit %>" />
										</asp:LinkButton>
																		
										<asp:LinkButton ID="btnUpdateEdited" runat="server" CommandName="UpdateEdited" OnClientClick="return UpdateClick(this);"
										Visible='<%# grdQuestionStatistic.EditIndexes.Count > 0 %>'>
											<img style="border:0px;vertical-align:middle;" alt="" src="../icons/Update.gif" />
											<asp:Literal ID="lblUpdate" runat="server" Text="<%$ Resources:Resource,Accept %>" />
										</asp:LinkButton>
																		
										<asp:LinkButton ID="btnCancel" runat="server" CommandName="CancelAll" 
										Visible='<%# grdQuestionStatistic.EditIndexes.Count > 0 || grdQuestionStatistic.MasterTableView.IsItemInserted %>'>
											<img style="border:0px;vertical-align:middle;" alt="" src="../icons/Cancel.gif" />
											<asp:Literal ID="lblCancel" runat="server" Text="<%$ Resources:Resource,Cancel %>" />
										</asp:LinkButton>
																		
										<asp:LinkButton ID="btnAdd" runat="server" CommandName="InitInsert" 
										Visible='<%# !grdQuestionStatistic.MasterTableView.IsItemInserted && grdQuestionStatistic.EditIndexes.Count == 0 %>'>
											<img style="border:0px;vertical-align:middle;" alt="" src="../icons/document_add.png" />
											<asp:Literal ID="lblAdd" runat="server" Text="<%$ Resources:Resource,Add %>" />
										</asp:LinkButton>
																		
										<asp:LinkButton ID="btnInsert" runat="server" CommandName="PerformInsert" 
										Visible='<%# grdQuestionStatistic.MasterTableView.IsItemInserted %>'>
											<img style="border:0px;vertical-align:middle;" alt="" src="../icons/Update.gif" />
											<asp:Literal ID="lblInsert" runat="server" Text="<%$ Resources:Resource,Accept %>" />
										</asp:LinkButton>
																		
										<asp:LinkButton ID="btnDelete" OnClientClick="return DeleteClick();"
										runat="server" CommandName="DeleteSelected" Visible='<%# !grdQuestionStatistic.MasterTableView.IsItemInserted %>'>
											<img style="border:0px;vertical-align:middle;" alt="" src="../icons/Selection_delete.png" />
											<asp:Literal ID="lblDelete" runat="server" Text="<%$ Resources:Resource,Delete %>" />
										</asp:LinkButton>
									</div>
								</CommandItemTemplate>
								<Columns>
									<telerik:GridClientSelectColumn UniqueName="Selected" >
										<HeaderStyle Width="25px" HorizontalAlign="Left" />
										<ItemStyle Width="25px" HorizontalAlign="Left" />
									</telerik:GridClientSelectColumn>
									
									<telerik:GridBoundColumn DataField="Id" Display="False" UniqueName="Id">
									</telerik:GridBoundColumn>
									
									<telerik:GridBoundColumn DataField="Name" HeaderText="<%$ Resources:Resource, QuestionStatisticName %>" UniqueName="StatisticName">
										<HeaderStyle Width="110px" Wrap="true" HorizontalAlign="Left" />
										<ItemStyle Width="110px" Wrap="true" HorizontalAlign="Left" />
									</telerik:GridBoundColumn>
									<telerik:GridDropDownColumn UniqueName="Variable" HeaderText="<%$ Resources:Resource,Variable %>" DataField="Variable" 
									DataSourceID="VariablesDataSource" ListValueField="Value" ListTextField="Text" DropDownControlType="DropDownList">
										<HeaderStyle Width="185px" Wrap="true" HorizontalAlign="Left" />
										<ItemStyle Width="185px" Wrap="true" HorizontalAlign="Left" />										
									</telerik:GridDropDownColumn>

									<telerik:GridDropDownColumn UniqueName="Operation" HeaderText="<%$ Resources:Resource,QuestionStatisticOperation %>" DataField="Operation" ListValueField="Value" 
									ListTextField="Text" DataSourceID="QuestionStatisticCreationOperationsDataSource" DropDownControlType="DropDownList">
										<HeaderStyle Width="90px" Wrap="true" HorizontalAlign="Left" />
										<ItemStyle Width="90px" Wrap="true" HorizontalAlign="Left" />
									</telerik:GridDropDownColumn>
									
									<telerik:GridDropDownColumn UniqueName="Option" HeaderText="<%$ Resources:Resource,Options %>" DataField="Option" 
									ListValueField="Value" ListTextField="Text" DataSourceID = "QuestionStatisticOptionsDataSource" DropDownControlType="DropDownList">
										<HeaderStyle Width="165px" Wrap="true" HorizontalAlign="Left" />
										<ItemStyle Width="165px" Wrap="true" HorizontalAlign="Left" />
									</telerik:GridDropDownColumn>
									
									<telerik:GridBoundColumn UniqueName="NbOfDecimals" HeaderText="<%$ Resources:Resource,Decimals %>" DataField="NbOfDecimals">
										<HeaderStyle Width="70px" Wrap="true" HorizontalAlign="Left" />
										<ItemStyle Width="70px" Wrap="true" HorizontalAlign="Left" />
									</telerik:GridBoundColumn>
									
									<telerik:GridBoundColumn DataField="LowDelimiter" HeaderText="<%$ Resources:Resource,LowDelimiter %>" UniqueName="LowDelimiter">
										<HeaderStyle Width="70px" Wrap="true" HorizontalAlign="Left" />
										<ItemStyle Width="70px" Wrap="true" HorizontalAlign="Left" />
									</telerik:GridBoundColumn>
									
									<telerik:GridBoundColumn DataField="HighDelimiter" HeaderText="<%$ Resources:Resource,HighDelimiter %>" UniqueName="HighDelimiter">
										<HeaderStyle Width="70px" Wrap="true" HorizontalAlign="Left" />
										<ItemStyle Width="70px" Wrap="true" HorizontalAlign="Left" />
									</telerik:GridBoundColumn>
									
									<telerik:GridBoundColumn DataField="CanBeDeleted" Display="False" UniqueName="CanBeDeleted">
									</telerik:GridBoundColumn>

								</Columns>									
							</MasterTableView>
						</telerik:RadGrid>
					</div>
				</telerik:RadAjaxPanel>
					
			</telerik:RadPageView>
			
		</telerik:radmultipage>
		</div>	
		
		<!-- TREE VIEW -->
		<div style="width: 34%; height: 450px; float: right;">
			<div style="float: left; width: 25px;" class="arrows">
				<asp:ImageButton ID="btnRemoveResultCode" runat="server" ToolTip="<%$ Resources:Resource, RemoveSelectetedItem %>" ImageUrl="~/icons/arrow_left_blue.png" OnClick="btnRemoveResultCode_OnClick" ImageAlign="AbsMiddle" />
			</div>
			
			<asp:Label ID="labelSelectedItems" runat="server" Text="<%$ Resources:Resource, SelectedStatisticsByResultCodes %>" CssClass="title" />
			<br />
			<asp:LinkButton ID="linkSelectAll" runat="server" Font-Size="10" Text="<%$ Resources:Resource, SelectAll %>" OnClientClick="javascript: return CheckGroupNodesAllNodes();" ></asp:LinkButton>
			<asp:LinkButton ID="LinkButton1" runat="server" Font-Size="10" Text="<%$ Resources:Resource, UnselectAll %>" OnClientClick="javascript: return UncheckGroupNodesAllNodes();"></asp:LinkButton>
			<asp:LinkButton ID="lnkMoveUp" runat="server" Text="<%$ Resources:Resource, MoveUp %>" OnClientClick="javascript: return lnkMoveUp_Click();" Font-Size="10"></asp:LinkButton>
			<asp:LinkButton ID="lnkMoveDown" runat="server" Text="<%$ Resources:Resource, MoveDown %>" OnClientClick="javascript: return lnkMoveDown_Click();" Font-Size="10"></asp:LinkButton>						

			<telerik:RadAjaxPanel ID="treeSelectedResultCodesAjaxPanel" runat="server" EnableAJAX="true" OnAjaxRequest="treeSelectedResultCodesAjaxPanel_OnAjaxRequest" LoadingPanelID="MainAjaxLoadingPanel">
				<div class="frame" style="width: 90%; margin-left: 25px;">		
					<telerik:radtreeview id="treeSelectedResultCodes" runat="server"				
						PostBackUrl="ReportStatisticsResultCode.aspx"
						MultipleSelect="True"
						AllowNodeEditing="True"
						SingleExpandPath="False"
						EnableDragAndDrop="True"
						EnableDragAndDropBetweenNodes="False"
						CheckBoxes="True"
						DataSourceID="SelectedResultCodeDataSource"
						DataValueField="NodeId"
						DataTextField="NodeLabel"
						DataFieldID="NodeId"
						DataFieldParentID="ParentNodeId"
						OnNodeDataBound="treeSelectedResultCodes_OnNodeBound"						
						OnClientNodeClicked="OnClickedNode"
						OnClientNodeChecked="OnCheckedNode"
						OnNodeDrop="treeSelectedResultCodes_HandleDrop"
						OnNodeEdit="treeSelectedResultCodes_HandleNodeEdit" 
						OnClientNodeDropping="treeSelectedDropTest"
						width="100%" Height="340px">
					</telerik:radtreeview>	
				</div>
			</telerik:RadAjaxPanel>
			
		</div>
	
	</telerik:RadAjaxPanel>	
</asp:Content>

